/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.knowledge.items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.knowledge.KnowledgeModule;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeManager;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;

public class LostKnowledgeItem
extends Item
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"pattern", this::getPatternString), TooltipBuilder.parameter((String)"reason", s -> this.getReasonString((ItemStack)s) != null, this::getReasonString)});
    private final DimletRarity rarity;

    private String getReasonString(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("reason")) {
            return tag.m_128461_("reason");
        }
        return null;
    }

    private String getPatternString(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("pattern")) {
            String pattern = tag.m_128461_("pattern");
            KnowledgeKey kkey = KnowledgeKey.create(pattern);
            return kkey.rarity().name().toLowerCase() + " " + kkey.type().name().toLowerCase();
        }
        return "<Unknown>";
    }

    public LostKnowledgeItem(DimletRarity rarity) {
        super(Registration.createStandardProperties());
        this.rarity = rarity;
    }

    public DimletRarity getRarity() {
        return this.rarity;
    }

    @Nullable
    public static KnowledgeKey getKnowledgeKey(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("pattern")) {
            String pattern = tag.m_128461_("pattern");
            return KnowledgeKey.create(pattern);
        }
        return null;
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flags) {
        super.m_7373_(itemStack, world, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flags);
    }

    public static ItemStack createUnresearchedLostKnowledge(DimletRarity rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case DimletRarity.COMMON -> new ItemStack((ItemLike)KnowledgeModule.COMMON_LOST_KNOWLEDGE.get());
            case DimletRarity.UNCOMMON -> new ItemStack((ItemLike)KnowledgeModule.UNCOMMON_LOST_KNOWLEDGE.get());
            case DimletRarity.RARE -> new ItemStack((ItemLike)KnowledgeModule.RARE_LOST_KNOWLEDGE.get());
            case DimletRarity.LEGENDARY -> new ItemStack((ItemLike)KnowledgeModule.LEGENDARY_LOST_KNOWLEDGE.get());
        };
    }

    public static ItemStack createLostKnowledge(Level world, DimletKey key) {
        KnowledgeKey kkey;
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings != null && (kkey = KnowledgeManager.get().getKnowledgeKey(LevelTools.getOverworld((Level)world).m_7328_(), key)) != null) {
            DimletRarity rarity = settings.getRarity();
            return LostKnowledgeItem.createLostKnowledgeStack(world, rarity, kkey);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack createRandomLostKnowledge(Level world, DimletRarity rarity, Random random) {
        List<KnowledgeKey> patterns = KnowledgeManager.get().getKnownPatterns(world, rarity);
        if (patterns.isEmpty()) {
            return ItemStack.f_41583_;
        }
        KnowledgeKey kkey = patterns.get(random.nextInt(patterns.size()));
        return LostKnowledgeItem.createLostKnowledgeStack(world, rarity, kkey);
    }

    private static ItemStack createLostKnowledgeStack(Level world, DimletRarity rarity, KnowledgeKey kkey) {
        LostKnowledgeItem item = LostKnowledgeItem.getKnowledgeItem(rarity);
        ItemStack result = new ItemStack((ItemLike)item);
        result.m_41784_().m_128359_("pattern", kkey.serialize());
        String reason = KnowledgeManager.get().getReason(world, kkey);
        if (reason != null) {
            result.m_41783_().m_128359_("reason", reason);
        }
        return result;
    }

    private static LostKnowledgeItem getKnowledgeItem(DimletRarity rarity) {
        KnowledgeModule.COMMON_LOST_KNOWLEDGE.get();
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case DimletRarity.COMMON -> (LostKnowledgeItem)KnowledgeModule.COMMON_LOST_KNOWLEDGE.get();
            case DimletRarity.UNCOMMON -> (LostKnowledgeItem)KnowledgeModule.UNCOMMON_LOST_KNOWLEDGE.get();
            case DimletRarity.RARE -> (LostKnowledgeItem)KnowledgeModule.RARE_LOST_KNOWLEDGE.get();
            case DimletRarity.LEGENDARY -> (LostKnowledgeItem)KnowledgeModule.LEGENDARY_LOST_KNOWLEDGE.get();
        };
    }
}

